/****************************************************************
 * sunos4_compatibility.h : Misc Definitions
 *
 * (c) 1995-1998 Yutaka Oiwa.
 *
 * This file may be used freely for any purpose, provided that
 * the original author is not responsible for any result of
 * the usage.
 *
 * $Id: sunos4_compatibility.h,v 1.4 2000/02/17 15:01:01 yutaka Exp $
 ****************************************************************/

#ifndef SUNOS4_COMPATIBILITY_H
#define SUNOS4_COMPATIBILITY_H

#define __USE_FIXED_PROTOTYPES__

#ifndef NULL
#define NULL 0
#endif

#ifndef NETDB_INTERNAL
#define NETDB_INTERNAL -1
#endif

#include <sys/types.h>
#include <errno.h>
#include <string.h>

typedef int socklen_t;

#ifdef __cplusplus
extern "C" {
#endif
  void bcopy(char *from, char *to, int len);
  int socket(int domain, int type, int protocol);
  int getsockopt(int s, int level, int optname, void *optval, int *optlen);
  int setsockopt(int s, int level, int optname,  const  void *optval, int optlen);
  int connect(int sockfd, struct sockaddr *serv_addr, int addrlen);
#ifdef __cplusplus
}
#endif
extern int sys_nerr;
extern char *sys_errlist[];
#ifdef __cplusplus
inline void memmove(char *to, char *from, int len)
{
  bcopy(from, to, len);
}

inline /*const*/ char *strerror(int e)
{
  if (e < 0 || e >= sys_nerr)
    return "Unknown Error.";
  return sys_errlist[e];
}

#else
#define memmove(from,to,len) bcopy((to),(from),(len))
#define strerror(e) ((e < 0 || e >= sys_nerr) \
		     ? "Unknown Error." \
		     : sys_errlist[e])
#endif
#endif
