#!/bin/sh
set -e
TMPDIR=/tmp/xitalkbiff-bin-distribute
OS=`uname`
OSREL=`uname -r`
if [ "$OS" = SunOS ]; then
  OS="$OS"`uname -r | sed -e 's/^\(.\)..*$/\1/'`
fi
ARCH=`uname -m`
case "$ARCH" in
  i[34567]86)
    ARCH=i386
    ;;
  sun4?)
    ARCH=sun4
    ;;
  *)
    ;;
esac
if [ "$OS" = Linux ]; then
  ARCH="$ARCH"-`ldd xitalkbiff | grep '^[ 	]*libc' | sed -e 's/^.*libc\.so\.\([5-9]\)..*$/libc\1/'`
fi
echo "Making Binary Package for $OS-$ARCH"
mkdir $TMPDIR $TMPDIR/xitalkbiff
cp `cat MANIFEST.binary-package` $TMPDIR/xitalkbiff
strip $TMPDIR/xitalkbiff/xitalkbiff
chmod -R go+rX $TMPDIR/*
VERSION=`perl -ne '(/#define VERSION "(.+)"/) && (print $1)' xitalkbiff.cc`
tar Ccvfz $TMPDIR ../xitalkbiff-$VERSION-$OS-$ARCH-bin.tar.gz `cat MANIFEST.binary-package | sed -e 's@^@xitalkbiff/@'`
rm -r $TMPDIR
