#include "async_dns.h"
#include <X11/Intrinsic.h>

static XtAppContext app;
static asyncdns_libentry_t sentry;
static asyncdns_libtentry_t tentry;
static int inited = 0;

static void X_cb_timer(void *s, XtIntervalId *id)
{
  if (!tentry)
    abort();
  tentry((int)s);
}

static void X_cb_socket(void *s, int *fdp, XtInputId *id)
{
  if (!sentry)
    abort();
  sentry(*fdp);
}

static void *treg(asyncdns_libtentry_t entry_, int id, int timeout)
{
  tentry = entry_;
  return (void *)XtAppAddTimeOut(app, timeout * 1000, X_cb_timer, (XtPointer)id);
}

static void trem(void *id)
{
  XtRemoveTimeOut((XtIntervalId)id);
}

static void *reg(asyncdns_libentry_t entry_, int fd)
{
  sentry = entry_;
  return (void *)XtAppAddInput(app, fd, (XtPointer)XtInputReadMask, X_cb_socket, 0);
}

static void rem(void *id, int fd)
{
  XtRemoveInput((XtInputId)id);
}

int asyncdns_X_init(XtAppContext app_)
{
  int ret;
  if (inited)
    return 1;
  app = app_;
  ret = asyncdns_init(reg, rem, treg, trem);
  if (ret)
    inited = 1;
  return ret;
}
