/****************************************************************
 *
 * async_dns_from_named.h : asyncronous dns lookup routines.
 *
 * Copyright (c) 1998 Yutaka Oiwa.
 *
 ****************************************************************/

#ifndef ASYNC_DNS_H_
#define ASYNC_DNS_H_
#include <netdb.h>
#ifdef __cplusplus
extern "C" {
#endif

  /* library_defined callback entry for data polling */
  typedef void (*asyncdns_libentry_t)(int fd);
  typedef void (*asyncdns_libtentry_t)(int id);
  /* user_defined callback entry for registering file descriptor */
  typedef void *(*asyncdns_regcallback_t)(asyncdns_libentry_t entry, int fd);
  typedef void (*asyncdns_remcallback_t)(void *id, int fd);
  typedef void *(*asyncdns_tregcallback_t)(asyncdns_libtentry_t entry, int id, int timeout);
  typedef void (*asyncdns_tremcallback_t)(void *id);
  
  /* user_defined callback entry for result */
  typedef void (*asyncdns_callback_t)(void *closure, int id, struct hostent *result);
  
  extern int asyncdns_init(asyncdns_regcallback_t regfunc, asyncdns_remcallback_t remfunc,
			   asyncdns_tregcallback_t tregfunc, asyncdns_tremcallback_t tremfunc);
  extern int asyncdns_gethostbyname(asyncdns_callback_t f, void *closure, 
				    struct hostent **resultp,
				    char *name);
  extern int asyncdns_gethostbyaddr(asyncdns_callback_t f, void *closure, 
				    struct hostent **resultp,
				    const char *, int, int);
  extern int asyncdns_abort_request(int id);
  int asyncdns_set_debug_level(int d);
#ifdef __cplusplus
};
#endif
#endif
