#include "async_dns.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
int sockfd;

asyncdns_libentry_t dataarrived;
int c = 0;

static char *herrors[] = {
  "Resolver Internal Error 0",
  "Resolver Error 0 (no error)",
  "Unknown host",                         /* 1 HOST_NOT_FOUND */
  "Host name lookup failure",             /* 2 TRY_AGAIN */
  "Unknown server error",                 /* 3 NO_RECOVERY */
  "No address associated with name",      /* 4 NO_ADDRESS */
};

void *test_regfunc(asyncdns_libentry_t f, int fd) {
  printf("registered func=%p, fd=%d\n", (void *)f, fd);
  dataarrived = f;
  sockfd = fd;
  return 0;
}
void test_remfunc(void *closure, int fd) {
  printf("unregistered fd=%d\n", fd);
}

void test_callback(void *closure, int id, struct hostent *result) {
  if (result) {
    if (result->h_addr)
      printf("callbacked closure=%d, id=%d, name=%s, addr=%s\n", (int)closure, id, result->h_name, 
	     inet_ntoa(*((struct in_addr *)result->h_addr)));
    else
      printf("callbacked closure=%d, id=%d, name=%s (no addr.)\n", (int)closure, id, result->h_name);
  } else {
    printf("callbacked closure=%d, id=%d, h_errno=%d (%s)\n", (int)closure, id, 
	   h_errno, herrors[h_errno + 1]);
  }
  c--;
}

int main(int argc, char **argv) {
  struct sockaddr_in cli;
  struct hostent *ent;
  int i, id;
  asyncdns_init(test_regfunc, test_remfunc, NULL, NULL);
  for(i = 1; i < argc; i++) {
    if (argv[i][0] == '/') {
      unsigned long int addr = inet_addr(&argv[i][1]);
      if ((int)addr == -1) {
	printf("%s is not a valid address.\n", &argv[i][1]);
	continue;
      }
      id = asyncdns_gethostbyaddr(test_callback, (char *)i, &ent, (char *)&addr, 4, AF_INET);
    } else
      id = asyncdns_gethostbyname(test_callback, (char *)i, &ent, argv[i]);
    c++;
    if (id < 0) {
      test_callback((char *)i, 0, 0);
    } else if (id == 0) {
      test_callback((char *)i, 0, ent);
    }
  }
  while(c) {
    dataarrived(sockfd);
  }
}
