/****************************************************************
 * LineBuffer.h : Block -> Line buffering
 *
 * (c) 1997 Yutaka Oiwa.
 *
 * You may distribute this file under the terms of license
 * agreement specified in the files README and LICENCE.
 *
 * $Id: LineBuffer.h,v 1.5 1999/12/28 13:13:32 yutaka Exp $
 ****************************************************************/

#ifndef _LINE_BUFFER_H
#define _LINE_BUFFER_H

class LineBuffer {
public:
  typedef void (*LineBuffer_callback_t)(void *app_data, char *buf, int len);
private:
  static const int MAXSIZE = 512;
  char buf[MAXSIZE+1];
  int buf_len, read;
  void *app_data;
  LineBuffer_callback_t callback;
public:
  LineBuffer(LineBuffer_callback_t callback_, void *app_data);
  void put(char *data, int len);
};

inline LineBuffer::LineBuffer(LineBuffer_callback_t callback_, void *app_data_)
{
  callback = callback_;
  app_data = app_data_;
  buf_len = read = 0;
}
#endif
