/****************************************************************
 * LineBuffer.cc : Block -> Line buffering
 *
 * (c) 1998 Yutaka Oiwa.
 *
 * You may distribute this file under the terms of license
 * agreement specified in the files README and LICENCE.
 *
 * $Id: LineBuffer.cc,v 1.5 1998/10/17 18:10:26 yutaka Exp $
 ****************************************************************/

#include "Defines.h"
#include "LineBuffer.h"
#include <string.h>

void LineBuffer::put(char *data, int len)
{
  if (len <= 0) {
    if (buf_len != 0)
      callback(app_data, buf, buf_len);
    callback(app_data, NULL, len - 1); // -1 for EOF, -2 for ERROR
    return;
  }
  for(int i = 0; i < len; i++) {
    if (data[i] == '\n') {
      buf[buf_len] = '\0';
      callback(app_data, buf, buf_len);
      buf_len = 0;
    } else {
      if (buf_len < MAXSIZE - 1)
	buf[buf_len++] = data[i];
    }
  }
}

   
