/****************************************************************
 * ItalkServer.h : Italk-Server status class
 *
 * (c) 1997-1998 Yutaka Oiwa.
 *
 * You may distribute this file under the terms of license
 * agreement specified in the files README and LICENCE.
 *
 * $Id: ItalkServer.h,v 1.9 1998/11/29 18:34:36 yutaka Exp $
 ****************************************************************/

#ifndef _ITALK_SERVER_H
#define _ITALK_SERVER_H

#include "Defines.h"
#include "Monkey.h"

const int MAX_MONKEY = 64;

typedef void (*ItalkServer_callback_t)(int, void *);
class ItalkServer 
{
private:
  // Monkey DATA
  char *name;
  int port;
  char *fullname;

  char *message[2];
  int mes_urgent[2];
  Monkey *monkeys[2][MAX_MONKEY + 1];
  int n_monkeys[2];
  int n_monkeys_in_mem[2];
  int add_to, cur;

  ItalkServer_callback_t callback;
  void *app_data;

public:
  ItalkServer(const char *name_, int port_, const char *fullname_,
	      ItalkServer_callback_t callback_, void *app_data_);
  void AddMessage(const char *p, int urgent = 0);
  void DeleteMessage();
  const char *GetMessage() const{return message[cur];}
  void AddMonkey(Monkey *p);
  void UpdateHandle(int, char *);
  void UpdateStatus(int, char *);
  void LogoutMonkey(int);
  void DataStart();
  void DataFinished();
  const Monkey *const * GetMonkeys() const;
  int Get_NumMonkeys() const {return n_monkeys[cur];}
  const char *Get_Name() const {return name;}
  const char *Get_FullName() const {return fullname;}
};
#endif
