/****************************************************************
 * ItalkServer.cc : Italk-Server status class
 *
 * (c) 1997-1998 Yutaka Oiwa.
 *
 * You may distribute this file under the terms of license
 * agreement specified in the files README and LICENCE.
 *
 * $Id: ItalkServer.cc,v 1.15 2005/06/01 13:57:55 yutaka Exp $
 ****************************************************************/

#include <stdlib.h>
#include "Defines.h"
#include "ItalkServer.h"

ItalkServer::ItalkServer(const char *name_, int port_, const char* fullname_,
			 ItalkServer_callback_t callback_, void *app_data_) {
  name = NewString(name_);
  port = port_;
  fullname = NewString(fullname_);
  callback = callback_;
  app_data = app_data_;

  add_to = 0;
  cur = 0;

  for (int i=0; i < 2; i++) {
    n_monkeys[i] = 0;
    n_monkeys_in_mem[i] = 0;
    message[i] = 0;
    mes_urgent[i] = 0;
    for (int j=0; j <= MAX_MONKEY; j++) {
      monkeys[i][j] = NULL;
      // monkeys[i][MAX_MONKEY] is a guardian.
    }
  }
}

const Monkey *const * ItalkServer::GetMonkeys(void) const {
  Dprintf(8, "GET_DATA: %d\n", cur);
  return monkeys[cur];
}

void ItalkServer::AddMonkey(Monkey *p) {
  Dprintf(8, "ADDMONKEY: %d,%p\n", add_to, p);
  if (n_monkeys_in_mem[add_to] < MAX_MONKEY) {
    monkeys[add_to][n_monkeys_in_mem[add_to]] = p;
    n_monkeys_in_mem[add_to]++;
    n_monkeys[add_to]++;
  } else {
    n_monkeys[add_to]++;
    delete p;
  }
  if (cur == add_to)
    if (callback)
      callback(1, app_data);
}

void ItalkServer::AddMessage(const char *p, int urgent) {
  Dprintf(8, "MESSAGE: %d,%s\n", add_to, p);
  if (message[add_to])
    delete[] message;
  message[add_to] = NewString(p);
  mes_urgent[add_to] = urgent;
}

void ItalkServer::DeleteMessage() {
  Dprintf(8, "MESSAGE: removed\n");
  if (message[add_to])
    delete[] message[add_to];
  message[add_to] = NULL;
  mes_urgent[add_to] = 0;
}

void ItalkServer::UpdateHandle(int id, char *handle) {
  for(int i = 0; i < MAX_MONKEY; i++) {
    if (!monkeys[cur][i]) {
      Dprintf(8, "handle = NOT FOUND(%d,%d)\n", cur, id);
      return;
    }
    if (monkeys[cur][i]->no == id) {
      Dprintf(8, "handle = FOUND(%d,%d)\n", cur, id);
      monkeys[cur][i]->UpdateHandle(handle);
      if (callback)
	callback(0, app_data);
      return;
    }
  }
}

void ItalkServer::UpdateStatus(int id, char *status) {
  for(int i = 0; i < MAX_MONKEY; i++) {
    if (!monkeys[cur][i]) {
      Dprintf(8, "status = NOT FOUND(%d,%d)\n", cur, id);
      return;
    }
    if (monkeys[cur][i]->no == id) {
      Dprintf(8, "status = FOUND(%d,%d)\n", cur, id);
      monkeys[cur][i]->UpdateStatus(status);
      if (callback)
	callback(0, app_data);
      return;
    }
  }
}

void ItalkServer::LogoutMonkey(int id) {
  for(int i = 0; i <= MAX_MONKEY; i++) { // including guadian
    if (!monkeys[cur][i]) {
      Dprintf(8, "logout = NOT FOUND(%d,%d)\n", cur, id);
      if (n_monkeys_in_mem[cur] < n_monkeys[cur]) {
	// MAX_MONKEY ¤ˤ桼ξڤΤƤ
	// 硢ڤΤƤ줿桼˴ؤȾ
	// Ϥ礬Τǡξ̵ǥ桼Υ󥿤
	// 1 餹
	n_monkeys[cur]--;
	if (callback)
	  callback(0, app_data);
      }
      return;
    }
    if (monkeys[cur][i]->no == id) {
      Dprintf(8, "logout = FOUND(%d,%d)\n", cur, id);
      Monkey *p = monkeys[cur][i];
      for(; monkeys[cur][i]; i++) {
	Dprintf(8, "  move (%d,%p)<-(%d,%p)\n", i,monkeys[cur][i], i+1,monkeys[cur][i+1]);
	monkeys[cur][i] = monkeys[cur][i + 1];
      }
      delete p;
      n_monkeys[add_to]--;
      n_monkeys_in_mem[add_to]--;
      if (callback)
	callback(0, app_data);
      return;
    }
  }
}

void ItalkServer::DataStart() {
  add_to = !cur;
  Dprintf(8, "add_to = %d, cur = %d\n", add_to, cur);

  n_monkeys[add_to] = 0;
  n_monkeys_in_mem[add_to] = 0;
  for(int i=0; i < MAX_MONKEY; i++)
    if (monkeys[add_to][i]) {
      delete monkeys[add_to][i];
      monkeys[add_to][i] = NULL;
    }
  if (message[add_to])
    delete[] message[add_to];
  message[add_to] = NULL;
  mes_urgent[add_to] = 0;

}

static int compare_monkeys(const void *a, const void *b)
{
  return (*(const Monkey **)a)->no - (*(const Monkey **)b)->no;
}

void ItalkServer::DataFinished() {
  // Italkplus 0.90beta3 does not sort entries (;_;)
  qsort(monkeys[add_to], n_monkeys_in_mem[add_to], sizeof (Monkey *), 
	compare_monkeys);
  int f = (n_monkeys[add_to] > n_monkeys[!add_to]) || mes_urgent[add_to];
  cur = add_to;
  Dprintf(8, "add_to = %d, cur = %d\n", add_to, cur);
  
  if (callback)
    callback(f, app_data);
}
