/****************************************************************
 * ItalkPipeConnection.h : Italk-Server connection class
 *
 * (c) 1997-1998 Yutaka Oiwa.
 *
 * You may distribute this file under the terms of license
 * agreement specified in the files README and LICENCE.
 *
 * $Id: ItalkPipeConnection.h,v 1.12 2002/04/22 18:25:06 yutaka Exp $
 ****************************************************************/

#ifndef _ITALK_PIPE_CONNECTION_H
#define _ITALK_PIPE_CONNECTION_H

#include "ItalkServer.h"
#include "LineBuffer.h"
#include <X11/Intrinsic.h>

class ItalkPipeConnection {
private:
  XtAppContext app;
  ItalkServer *ser;
  char *fullname;
  int port;
  int waittime, keepalivetime;

  int num;
  char name[80], where[80], stat[80];
  int protocol;
  
  enum status_t { INIT, NAME_WAIT, CONN_WAIT, CONN, FAILED, WRONGPORT_1, HALT } status;
  bool update_allowed;
  bool in_italk_section, in_user_section;
  bool allow_fallback;

  int soc;
  LineBuffer lbuf;
  XtInputId input_id;
  XtIntervalId interval_id;
  XtIntervalId keepalive_id;
  
  friend void name_resolved(void *, int, struct hostent *);
  friend void cb_line_arrived(void *, char *, int);
  friend void cb_X_time_elapsed(void *, XtIntervalId*);
  friend void cb_X_keepalive_elapsed(void *, XtIntervalId*);
  friend void cb_X_connected(void *, int *, XtInputId*);
  friend void cb_X_data_arrived(void *, int *, XtInputId*);
  void getline(char *line, int len);
  void wrongport_process(char *line, int len);

  void set_state(enum status_t);
  void make_connection();
  void connect_to_server(unsigned long int addr);

  void connect_failed(int);
  void connect_established();

public:
  ItalkServer *Server() {return ser;}
    ItalkPipeConnection(XtAppContext context, char *host, int waittime_, int keepalivetime_,
		      ItalkServer_callback_t callback,
		      void *app_data);
  ~ItalkPipeConnection();
};

#endif
