/****************************************************************
 * Defines.h : Misc Definitions
 *
 * (c) 1995-1998 Yutaka Oiwa.
 *
 * You may distribute this file under the terms of license
 * agreement specified in the files README and LICENCE.
 *
 * $Id: Defines.h,v 1.13 2005/06/01 13:57:55 yutaka Exp $
 ****************************************************************/

#ifndef _DEFINES_H
#define _DEFINES_H

#if defined(sun) && !defined(__svr4__)
#include "sunos4_compatibility.h"
#endif

/*** Configulation ***/
#define DEBUG
//#define NO_ASYNC_CONNECT     // Disables asynchronous connection
#define OLD_COMPAT             // Accepts italkpipe as server

#ifdef DEBUG
extern int Debug_Level;
#include <stdio.h>
void Dprintf(int d, char *p, ...);
void Dperror(int d, char *p);

#else
inline void Dprintf(int, char *, ...){}
inline void Dperror(int, char *){}
#endif

#define dprintf Dont_use_dprintf_because_glibc_is_awful
#define dperror Dont_use_dperror_because_glibc_is_awful

char *NewString(const char *); // definition found in xitalkbiff.cc

#undef max
inline int max(int x, int y) { return (x > y) ? x : y; }

#endif

#ifndef NETDB_INTERNAL
#define NETDB_INTERNAL (-1)
#endif
