type token =
    INT of (int)
  | IDENT of (string)
  | LPAREN
  | RPAREN
  | LBRACKET
  | RBRACKET
  | BAR
  | PLUS
  | MINUS
  | TIMES
  | DIV
  | EQUAL
  | EOD
  | IF
  | THEN
  | ELSE
  | LET
  | REC
  | IN
  | AND
  | CONS
  | SEMICOLON
  | COMMA
  | FUN
  | FUNCTION
  | ARROW
  | MATCH
  | WITH
  | FALSE
  | TRUE

open Parsing
# 2 "miniMLParser.mly"
open MiniML
(* 1 [2; 3] -> App(1,2) [3] -> A(A(1,2),3) [] *)
let rec make_appl x = function
    [] -> x
  | y::ys -> make_appl (App(x,y)) ys
let rec make_list = function
    [] -> Const(Nil)
  | y::ys -> ConsExp(y,make_list ys)
let rec make_list_ptn = function
    [] -> ConstPtn(Nil)
  | y::ys -> ConsPtn(y,make_list_ptn ys)
let rec make_fun e = function
    [] -> e
  | y::ys -> LambdaExp([y, make_fun e ys])
(* Line 18, file miniMLParser.ml *)
let yytransl_const = [|
  259 (* LPAREN *);
  260 (* RPAREN *);
  261 (* LBRACKET *);
  262 (* RBRACKET *);
  263 (* BAR *);
  264 (* PLUS *);
  265 (* MINUS *);
  266 (* TIMES *);
  267 (* DIV *);
  268 (* EQUAL *);
  269 (* EOD *);
  270 (* IF *);
  271 (* THEN *);
  272 (* ELSE *);
  273 (* LET *);
  274 (* REC *);
  275 (* IN *);
  276 (* AND *);
  277 (* CONS *);
  278 (* SEMICOLON *);
  279 (* COMMA *);
  280 (* FUN *);
  281 (* FUNCTION *);
  282 (* ARROW *);
  283 (* MATCH *);
  284 (* WITH *);
  285 (* FALSE *);
  286 (* TRUE *);
    0|]

let yytransl_block = [|
  257 (* INT *);
  258 (* IDENT *);
    0|]

let yylhs = "\255\255\
\001\000\001\000\002\000\002\000\002\000\005\000\005\000\005\000\
\005\000\005\000\005\000\005\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\004\000\004\000\010\000\008\000\008\000\
\011\000\006\000\006\000\009\000\009\000\007\000\007\000\012\000\
\012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
\013\000\013\000\000\000"

let yylen = "\002\000\
\002\000\001\000\001\000\002\000\003\000\001\000\001\000\001\000\
\001\000\003\000\002\000\003\000\001\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\004\000\002\000\002\000\006\000\
\004\000\004\000\005\000\001\000\003\000\003\000\003\000\001\000\
\003\000\001\000\003\000\001\000\002\000\001\000\002\000\003\000\
\001\000\001\000\001\000\002\000\001\000\003\000\003\000\003\000\
\001\000\003\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\002\000\006\000\009\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\008\000\007\000\051\000\000\000\
\000\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\
\041\000\045\000\000\000\000\000\000\000\043\000\042\000\000\000\
\000\000\028\000\000\000\000\000\000\000\032\000\000\000\000\000\
\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\036\000\000\000\000\000\000\000\010\000\012\000\000\000\000\000\
\000\000\044\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\018\000\019\000\000\000\000\000\000\000\037\000\000\000\
\000\000\000\000\040\000\048\000\000\000\000\000\000\000\029\000\
\000\000\000\000\000\000\000\000\031\000\000\000\000\000\000\000\
\000\000\000\000\000\000"

let yydgoto = "\002\000\
\015\000\016\000\017\000\032\000\018\000\023\000\033\000\037\000\
\050\000\034\000\038\000\035\000\060\000"

let yysindex = "\003\000\
\071\255\000\000\000\000\000\000\000\000\173\255\101\255\173\255\
\109\255\226\255\226\255\173\255\000\000\000\000\000\000\250\254\
\078\001\244\255\214\255\249\255\000\000\078\001\002\255\054\001\
\000\000\000\000\226\255\017\255\226\255\000\000\000\000\251\254\
\221\255\000\000\238\254\052\255\009\255\000\000\068\255\033\001\
\000\000\173\255\173\255\173\255\173\255\173\255\173\255\173\255\
\000\000\244\255\226\255\251\254\000\000\000\000\173\255\173\255\
\008\255\000\000\238\254\003\255\041\255\173\255\226\255\173\255\
\238\254\226\255\226\255\173\255\226\255\173\255\226\255\098\255\
\098\255\000\000\000\000\185\255\185\255\039\001\000\000\041\255\
\078\001\062\001\000\000\000\000\226\255\173\255\078\001\000\000\
\078\001\013\255\013\255\078\001\000\000\078\001\009\255\173\255\
\238\254\078\001\078\001"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\035\255\015\000\000\000\000\000\000\000\011\255\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\255\
\000\000\000\000\179\255\000\000\059\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\038\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\022\255\000\000\050\255\000\000\000\000\000\000\
\209\255\000\000\000\000\000\000\000\000\000\000\000\000\103\000\
\126\000\000\000\000\000\146\000\166\000\186\000\000\000\000\000\
\045\255\000\000\000\000\000\000\000\000\000\000\206\000\000\000\
\073\255\131\255\143\255\223\000\000\000\240\000\080\000\000\000\
\053\255\001\001\018\001"

let yygindex = "\000\000\
\000\000\000\000\250\255\248\255\251\255\000\000\020\000\254\255\
\000\000\014\000\010\000\255\255\000\000"

let yytablesize = 613
let yytable = "\020\000\
\022\000\024\000\066\000\001\000\067\000\040\000\041\000\054\000\
\084\000\039\000\052\000\083\000\049\000\062\000\063\000\069\000\
\034\000\025\000\026\000\027\000\061\000\028\000\058\000\055\000\
\085\000\057\000\059\000\049\000\066\000\036\000\067\000\065\000\
\034\000\066\000\065\000\072\000\073\000\074\000\075\000\076\000\
\077\000\078\000\080\000\049\000\079\000\030\000\031\000\003\000\
\081\000\082\000\035\000\004\000\025\000\026\000\027\000\087\000\
\028\000\089\000\050\000\086\000\063\000\092\000\005\000\094\000\
\090\000\091\000\035\000\039\000\095\000\039\000\003\000\004\000\
\005\000\006\000\050\000\007\000\088\000\068\000\093\000\098\000\
\030\000\031\000\000\000\097\000\008\000\030\000\000\000\009\000\
\066\000\099\000\067\000\030\000\030\000\070\000\010\000\011\000\
\000\000\012\000\000\000\013\000\014\000\004\000\005\000\006\000\
\000\000\007\000\021\000\044\000\045\000\025\000\026\000\027\000\
\000\000\028\000\008\000\000\000\000\000\019\000\000\000\000\000\
\000\000\000\000\000\000\000\000\010\000\011\000\029\000\012\000\
\000\000\013\000\014\000\046\000\046\000\046\000\046\000\046\000\
\046\000\030\000\031\000\000\000\000\000\000\000\046\000\047\000\
\047\000\047\000\047\000\047\000\047\000\000\000\000\000\000\000\
\046\000\046\000\047\000\000\000\046\000\000\000\000\000\046\000\
\046\000\000\000\000\000\000\000\047\000\047\000\000\000\000\000\
\047\000\000\000\000\000\047\000\047\000\004\000\005\000\006\000\
\000\000\007\000\000\000\038\000\038\000\038\000\000\000\038\000\
\000\000\000\000\008\000\000\000\000\000\019\000\038\000\000\000\
\042\000\043\000\044\000\045\000\010\000\011\000\000\000\012\000\
\000\000\013\000\014\000\000\000\038\000\047\000\000\000\038\000\
\038\000\039\000\039\000\039\000\000\000\039\000\025\000\026\000\
\027\000\000\000\028\000\000\000\039\000\025\000\026\000\027\000\
\000\000\028\000\025\000\026\000\027\000\000\000\028\000\051\000\
\064\000\000\000\039\000\000\000\000\000\039\000\039\000\000\000\
\000\000\000\000\030\000\031\000\004\000\005\000\006\000\000\000\
\007\000\030\000\031\000\000\000\053\000\000\000\030\000\031\000\
\042\000\043\000\044\000\045\000\046\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\047\000\000\000\048\000\
\013\000\014\000\013\000\000\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\000\000\013\000\013\000\000\000\
\000\000\013\000\013\000\013\000\013\000\013\000\000\000\000\000\
\000\000\023\000\013\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\000\000\023\000\023\000\000\000\000\000\
\023\000\023\000\023\000\023\000\023\000\000\000\022\000\000\000\
\022\000\023\000\022\000\022\000\022\000\022\000\022\000\022\000\
\000\000\022\000\022\000\000\000\000\000\022\000\022\000\022\000\
\022\000\022\000\000\000\025\000\000\000\025\000\022\000\025\000\
\025\000\025\000\025\000\025\000\025\000\000\000\025\000\025\000\
\000\000\000\000\025\000\025\000\025\000\025\000\025\000\000\000\
\000\000\000\000\016\000\025\000\016\000\016\000\016\000\016\000\
\000\000\000\000\016\000\016\000\000\000\016\000\016\000\000\000\
\000\000\016\000\016\000\016\000\016\000\016\000\000\000\000\000\
\000\000\017\000\016\000\017\000\017\000\017\000\017\000\000\000\
\000\000\017\000\017\000\000\000\017\000\017\000\000\000\000\000\
\017\000\017\000\017\000\017\000\017\000\020\000\000\000\020\000\
\020\000\017\000\000\000\000\000\000\000\020\000\020\000\000\000\
\020\000\020\000\000\000\000\000\020\000\020\000\000\000\020\000\
\020\000\015\000\000\000\015\000\015\000\020\000\000\000\000\000\
\000\000\015\000\015\000\000\000\015\000\015\000\000\000\000\000\
\015\000\015\000\000\000\015\000\015\000\014\000\000\000\014\000\
\014\000\015\000\000\000\000\000\000\000\000\000\014\000\000\000\
\014\000\014\000\000\000\000\000\014\000\014\000\000\000\014\000\
\014\000\026\000\000\000\026\000\026\000\014\000\000\000\000\000\
\000\000\000\000\026\000\000\000\026\000\026\000\000\000\000\000\
\026\000\026\000\021\000\026\000\021\000\021\000\000\000\000\000\
\000\000\026\000\000\000\021\000\000\000\021\000\021\000\000\000\
\000\000\021\000\021\000\033\000\021\000\033\000\033\000\000\000\
\000\000\000\000\021\000\000\000\033\000\000\000\033\000\033\000\
\000\000\000\000\033\000\033\000\027\000\033\000\027\000\027\000\
\000\000\000\000\000\000\033\000\000\000\027\000\000\000\027\000\
\027\000\000\000\000\000\027\000\027\000\024\000\027\000\024\000\
\024\000\000\000\000\000\000\000\027\000\000\000\024\000\000\000\
\024\000\024\000\000\000\000\000\024\000\024\000\000\000\024\000\
\042\000\043\000\044\000\045\000\046\000\024\000\042\000\043\000\
\044\000\045\000\046\000\000\000\000\000\047\000\000\000\048\000\
\000\000\000\000\000\000\047\000\071\000\042\000\043\000\044\000\
\045\000\046\000\000\000\000\000\056\000\042\000\043\000\044\000\
\045\000\046\000\047\000\000\000\048\000\096\000\000\000\000\000\
\000\000\000\000\047\000\000\000\048\000\042\000\043\000\044\000\
\045\000\046\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\047\000\000\000\048\000"

let yycheck = "\006\000\
\007\000\008\000\021\001\001\000\023\001\012\000\013\001\006\001\
\006\001\011\000\019\000\004\001\018\000\019\001\020\001\007\001\
\006\001\001\001\002\001\003\001\029\000\005\001\006\001\022\001\
\022\001\027\000\028\000\006\001\021\001\010\000\023\001\033\000\
\022\001\021\001\036\000\042\000\043\000\044\000\045\000\046\000\
\047\000\048\000\051\000\022\001\050\000\029\001\030\001\013\001\
\055\000\056\000\006\001\013\001\001\001\002\001\003\001\062\000\
\005\001\064\000\006\001\019\001\020\001\068\000\013\001\070\000\
\066\000\067\000\022\001\069\000\071\000\071\000\000\001\001\001\
\002\001\003\001\022\001\005\001\063\000\026\001\069\000\086\000\
\029\001\030\001\255\255\085\000\014\001\013\001\255\255\017\001\
\021\001\096\000\023\001\019\001\020\001\026\001\024\001\025\001\
\255\255\027\001\255\255\029\001\030\001\001\001\002\001\003\001\
\255\255\005\001\006\001\010\001\011\001\001\001\002\001\003\001\
\255\255\005\001\014\001\255\255\255\255\017\001\255\255\255\255\
\255\255\255\255\255\255\255\255\024\001\025\001\018\001\027\001\
\255\255\029\001\030\001\001\001\002\001\003\001\004\001\005\001\
\006\001\029\001\030\001\255\255\255\255\255\255\012\001\001\001\
\002\001\003\001\004\001\005\001\006\001\255\255\255\255\255\255\
\022\001\023\001\012\001\255\255\026\001\255\255\255\255\029\001\
\030\001\255\255\255\255\255\255\022\001\023\001\255\255\255\255\
\026\001\255\255\255\255\029\001\030\001\001\001\002\001\003\001\
\255\255\005\001\255\255\001\001\002\001\003\001\255\255\005\001\
\255\255\255\255\014\001\255\255\255\255\017\001\012\001\255\255\
\008\001\009\001\010\001\011\001\024\001\025\001\255\255\027\001\
\255\255\029\001\030\001\255\255\026\001\021\001\255\255\029\001\
\030\001\001\001\002\001\003\001\255\255\005\001\001\001\002\001\
\003\001\255\255\005\001\255\255\012\001\001\001\002\001\003\001\
\255\255\005\001\001\001\002\001\003\001\255\255\005\001\018\001\
\012\001\255\255\026\001\255\255\255\255\029\001\030\001\255\255\
\255\255\255\255\029\001\030\001\001\001\002\001\003\001\255\255\
\005\001\029\001\030\001\255\255\004\001\255\255\029\001\030\001\
\008\001\009\001\010\001\011\001\012\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\021\001\255\255\023\001\
\029\001\030\001\004\001\255\255\006\001\007\001\008\001\009\001\
\010\001\011\001\012\001\013\001\255\255\015\001\016\001\255\255\
\255\255\019\001\020\001\021\001\022\001\023\001\255\255\255\255\
\255\255\004\001\028\001\006\001\007\001\008\001\009\001\010\001\
\011\001\012\001\013\001\255\255\015\001\016\001\255\255\255\255\
\019\001\020\001\021\001\022\001\023\001\255\255\004\001\255\255\
\006\001\028\001\008\001\009\001\010\001\011\001\012\001\013\001\
\255\255\015\001\016\001\255\255\255\255\019\001\020\001\021\001\
\022\001\023\001\255\255\004\001\255\255\006\001\028\001\008\001\
\009\001\010\001\011\001\012\001\013\001\255\255\015\001\016\001\
\255\255\255\255\019\001\020\001\021\001\022\001\023\001\255\255\
\255\255\255\255\004\001\028\001\006\001\007\001\008\001\009\001\
\255\255\255\255\012\001\013\001\255\255\015\001\016\001\255\255\
\255\255\019\001\020\001\021\001\022\001\023\001\255\255\255\255\
\255\255\004\001\028\001\006\001\007\001\008\001\009\001\255\255\
\255\255\012\001\013\001\255\255\015\001\016\001\255\255\255\255\
\019\001\020\001\021\001\022\001\023\001\004\001\255\255\006\001\
\007\001\028\001\255\255\255\255\255\255\012\001\013\001\255\255\
\015\001\016\001\255\255\255\255\019\001\020\001\255\255\022\001\
\023\001\004\001\255\255\006\001\007\001\028\001\255\255\255\255\
\255\255\012\001\013\001\255\255\015\001\016\001\255\255\255\255\
\019\001\020\001\255\255\022\001\023\001\004\001\255\255\006\001\
\007\001\028\001\255\255\255\255\255\255\255\255\013\001\255\255\
\015\001\016\001\255\255\255\255\019\001\020\001\255\255\022\001\
\023\001\004\001\255\255\006\001\007\001\028\001\255\255\255\255\
\255\255\255\255\013\001\255\255\015\001\016\001\255\255\255\255\
\019\001\020\001\004\001\022\001\006\001\007\001\255\255\255\255\
\255\255\028\001\255\255\013\001\255\255\015\001\016\001\255\255\
\255\255\019\001\020\001\004\001\022\001\006\001\007\001\255\255\
\255\255\255\255\028\001\255\255\013\001\255\255\015\001\016\001\
\255\255\255\255\019\001\020\001\004\001\022\001\006\001\007\001\
\255\255\255\255\255\255\028\001\255\255\013\001\255\255\015\001\
\016\001\255\255\255\255\019\001\020\001\004\001\022\001\006\001\
\007\001\255\255\255\255\255\255\028\001\255\255\013\001\255\255\
\015\001\016\001\255\255\255\255\019\001\020\001\255\255\022\001\
\008\001\009\001\010\001\011\001\012\001\028\001\008\001\009\001\
\010\001\011\001\012\001\255\255\255\255\021\001\255\255\023\001\
\255\255\255\255\255\255\021\001\028\001\008\001\009\001\010\001\
\011\001\012\001\255\255\255\255\015\001\008\001\009\001\010\001\
\011\001\012\001\021\001\255\255\023\001\016\001\255\255\255\255\
\255\255\255\255\021\001\255\255\023\001\008\001\009\001\010\001\
\011\001\012\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\021\001\255\255\023\001"

let yynames_const = "\
  LPAREN\000\
  RPAREN\000\
  LBRACKET\000\
  RBRACKET\000\
  BAR\000\
  PLUS\000\
  MINUS\000\
  TIMES\000\
  DIV\000\
  EQUAL\000\
  EOD\000\
  IF\000\
  THEN\000\
  ELSE\000\
  LET\000\
  REC\000\
  IN\000\
  AND\000\
  CONS\000\
  SEMICOLON\000\
  COMMA\000\
  FUN\000\
  FUNCTION\000\
  ARROW\000\
  MATCH\000\
  WITH\000\
  FALSE\000\
  TRUE\000\
  "

let yynames_block = "\
  INT\000\
  IDENT\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'toplevel_phrase) in
    Obj.repr((
# 47 "miniMLParser.mly"
                        _1 ) : MiniML.expr))
; (fun parser_env ->
    Obj.repr((
# 48 "miniMLParser.mly"
          failwith("parse failed.") ) : MiniML.expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 51 "miniMLParser.mly"
         _1 ) : 'toplevel_phrase))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'let_bindings) in
    Obj.repr((
# 53 "miniMLParser.mly"
      TopLetExp(List.rev _2) ) : 'toplevel_phrase))
; (fun parser_env ->
    let _3 = (peek_val parser_env 0 : 'let_bindings) in
    Obj.repr((
# 55 "miniMLParser.mly"
      TopLetRecExp(List.rev _3) ) : 'toplevel_phrase))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : int) in
    Obj.repr((
# 58 "miniMLParser.mly"
        Const(Int _1) ) : 'simple_expr))
; (fun parser_env ->
    Obj.repr((
# 59 "miniMLParser.mly"
         Const(Bool true) ) : 'simple_expr))
; (fun parser_env ->
    Obj.repr((
# 60 "miniMLParser.mly"
          Const(Bool false) ) : 'simple_expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : string) in
    Obj.repr((
# 61 "miniMLParser.mly"
          Var(_1) ) : 'simple_expr))
; (fun parser_env ->
    let _2 = (peek_val parser_env 1 : 'expr) in
    Obj.repr((
# 62 "miniMLParser.mly"
                       _2 ) : 'simple_expr))
; (fun parser_env ->
    Obj.repr((
# 63 "miniMLParser.mly"
                      Const(Nil) ) : 'simple_expr))
; (fun parser_env ->
    let _2 = (peek_val parser_env 1 : 'expr_semi_list) in
    Obj.repr((
# 64 "miniMLParser.mly"
                                     make_list(List.rev _2) ) : 'simple_expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'simple_expr) in
    Obj.repr((
# 67 "miniMLParser.mly"
                _1 ) : 'expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'expr) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 68 "miniMLParser.mly"
                    PairExp(_1,_3) ) : 'expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'expr) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 69 "miniMLParser.mly"
                   ConsExp(_1,_3) ) : 'expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'expr) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 70 "miniMLParser.mly"
                   Plus(_1,_3) ) : 'expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'expr) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 71 "miniMLParser.mly"
                    Minus(_1,_3) ) : 'expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'expr) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 72 "miniMLParser.mly"
                    Times(_1,_3) ) : 'expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'expr) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 73 "miniMLParser.mly"
                  Div(_1,_3) ) : 'expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'expr) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 74 "miniMLParser.mly"
                    Equal(_1,_3) ) : 'expr))
; (fun parser_env ->
    let _2 = (peek_val parser_env 2 : 'patterns) in
    let _4 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 76 "miniMLParser.mly"
      make_fun _4 (List.rev _2) ) : 'expr))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'multiple_matches) in
    Obj.repr((
# 78 "miniMLParser.mly"
      LambdaExp(List.rev _2) ) : 'expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'simple_expr) in
    let _2 = (peek_val parser_env 0 : 'expr_list) in
    Obj.repr((
# 80 "miniMLParser.mly"
      make_appl _1 (List.rev _2) ) : 'expr))
; (fun parser_env ->
    let _2 = (peek_val parser_env 4 : 'expr) in
    let _4 = (peek_val parser_env 2 : 'expr) in
    let _6 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 82 "miniMLParser.mly"
      IfExp(_2,_4,_6) ) : 'expr))
; (fun parser_env ->
    let _2 = (peek_val parser_env 2 : 'expr) in
    let _4 = (peek_val parser_env 0 : 'multiple_matches) in
    Obj.repr((
# 84 "miniMLParser.mly"
      MatchExp(_2,List.rev _4) ) : 'expr))
; (fun parser_env ->
    let _2 = (peek_val parser_env 2 : 'let_bindings) in
    let _4 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 86 "miniMLParser.mly"
      LetExp(List.rev _2,_4) ) : 'expr))
; (fun parser_env ->
    let _3 = (peek_val parser_env 2 : 'let_bindings) in
    let _5 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 88 "miniMLParser.mly"
      LetRecExp(List.rev _3,_5) ) : 'expr))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'let_binding) in
    Obj.repr((
# 91 "miniMLParser.mly"
                [_1] ) : 'let_bindings))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'let_bindings) in
    let _3 = (peek_val parser_env 0 : 'let_binding) in
    Obj.repr((
# 92 "miniMLParser.mly"
                                 _3 :: _1 ) : 'let_bindings))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'patterns) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 94 "miniMLParser.mly"
                        
    match List.rev _1 with
      [p] -> p, _3 
    | (IdentPtn i as p1)::ps -> p1, make_fun _3 ps 
    | _ -> failwith "parse failed at let_binding" ) : 'let_binding))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'multiple_matches) in
    let _3 = (peek_val parser_env 0 : 'sgl_match) in
    Obj.repr((
# 100 "miniMLParser.mly"
                                   _3 :: _1 ) : 'multiple_matches))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'sgl_match) in
    Obj.repr((
# 101 "miniMLParser.mly"
              [_1] ) : 'multiple_matches))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'pattern) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 104 "miniMLParser.mly"
                       _1, _3 ) : 'sgl_match))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 107 "miniMLParser.mly"
         [_1] ) : 'expr_semi_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'expr_semi_list) in
    let _3 = (peek_val parser_env 0 : 'expr) in
    Obj.repr((
# 108 "miniMLParser.mly"
                                  _3 :: _1 ) : 'expr_semi_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'simple_expr) in
    Obj.repr((
# 111 "miniMLParser.mly"
                [_1] ) : 'expr_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'expr_list) in
    let _2 = (peek_val parser_env 0 : 'simple_expr) in
    Obj.repr((
# 112 "miniMLParser.mly"
                          _2 :: _1 ) : 'expr_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'pattern) in
    Obj.repr((
# 115 "miniMLParser.mly"
            [_1] ) : 'patterns))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'patterns) in
    let _2 = (peek_val parser_env 0 : 'pattern) in
    Obj.repr((
# 116 "miniMLParser.mly"
                     _2 :: _1 ) : 'patterns))
; (fun parser_env ->
    let _2 = (peek_val parser_env 1 : 'pattern) in
    Obj.repr((
# 119 "miniMLParser.mly"
                          _2 ) : 'pattern))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : int) in
    Obj.repr((
# 120 "miniMLParser.mly"
        ConstPtn(Int _1) ) : 'pattern))
; (fun parser_env ->
    Obj.repr((
# 121 "miniMLParser.mly"
         ConstPtn(Bool true) ) : 'pattern))
; (fun parser_env ->
    Obj.repr((
# 122 "miniMLParser.mly"
          ConstPtn(Bool false) ) : 'pattern))
; (fun parser_env ->
    Obj.repr((
# 123 "miniMLParser.mly"
                      ConstPtn(Nil) ) : 'pattern))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : string) in
    Obj.repr((
# 124 "miniMLParser.mly"
          IdentPtn(_1) ) : 'pattern))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'pattern) in
    let _3 = (peek_val parser_env 0 : 'pattern) in
    Obj.repr((
# 125 "miniMLParser.mly"
                         ConsPtn(_1,_3) ) : 'pattern))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'pattern) in
    let _3 = (peek_val parser_env 0 : 'pattern) in
    Obj.repr((
# 126 "miniMLParser.mly"
                          PairPtn(_1,_3) ) : 'pattern))
; (fun parser_env ->
    let _2 = (peek_val parser_env 1 : 'pattern_semi_list) in
    Obj.repr((
# 127 "miniMLParser.mly"
                                        make_list_ptn(List.rev _2) ) : 'pattern))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'pattern) in
    Obj.repr((
# 129 "miniMLParser.mly"
            [_1] ) : 'pattern_semi_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'pattern_semi_list) in
    let _3 = (peek_val parser_env 0 : 'pattern) in
    Obj.repr((
# 130 "miniMLParser.mly"
                                        _3 :: _1 ) : 'pattern_semi_list))
(* Entry main *)
; (fun parser_env -> raise (YYexit (peek_val parser_env 0)))
|]
let yytables =
  { actions=yyact;
    transl_const=yytransl_const;
    transl_block=yytransl_block;
    lhs=yylhs;
    len=yylen;
    defred=yydefred;
    dgoto=yydgoto;
    sindex=yysindex;
    rindex=yyrindex;
    gindex=yygindex;
    tablesize=yytablesize;
    table=yytable;
    check=yycheck;
    error_function=parse_error;
    names_const=yynames_const;
    names_block=yynames_block }
let main (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (yyparse yytables 1 lexfun lexbuf : MiniML.expr)
