{
 open MiniML
 open MiniMLParser
 exception Eof
 let identifier_of s = List.assoc s 
     [ "if", IF;
       "then", THEN;
       "else", ELSE;
       "fun", FUN;
       "function", FUNCTION;
       "match", MATCH;
       "with", WITH;
       "false", FALSE;
       "true", TRUE;
       "let", LET;
       "rec", REC;
       "in", IN;
       "and", AND;
     ] 
} 
let lowercase = ['a'-'z' '_']
let uppercase = ['A'-'Z']
let identchar = 
  ['A'-'Z' 'a'-'z' '_' '\'' '0'-'9']

rule token = parse
  [' ' '\t' '\n'] { token lexbuf }
| ";;" { EOD }
| ['0'-'9']+ { INT(int_of_string(Lexing.lexeme lexbuf)) }
| "::" { CONS }
| ";" { SEMICOLON }
| "|" { BAR }
| "[" { LBRACKET }
| "]" { RBRACKET }
| "->" { ARROW }
| lowercase identchar * { let s = Lexing.lexeme lexbuf in
			try identifier_of(s) with _ -> IDENT(s) }
| '+' { PLUS }
| '-' { MINUS }
| '*' { TIMES }
| '/' { DIV }
| '=' { EQUAL }
| '(' { LPAREN }
| ')' { RPAREN }
| ',' { COMMA }
| eof { raise Eof }

    
