# 1 "miniMLLexer.mll"
 
 open MiniML
 open MiniMLParser
 exception Eof
 let identifier_of s = List.assoc s 
     [ "if", IF;
       "then", THEN;
       "else", ELSE;
       "fun", FUN;
       "function", FUNCTION;
       "match", MATCH;
       "with", WITH;
       "false", FALSE;
       "true", TRUE;
       "let", LET;
       "rec", REC;
       "in", IN;
       "and", AND;
     ] 
let lex_tables = {
  Lexing.lex_base = 
   "\000\000\255\255\240\255\239\255\243\255\245\255\238\255\000\000\
    \242\255\015\000\002\000\014\000\241\255\249\255\248\255\084\000\
    \250\255\237\255\254\255\252\255\247\255";
  Lexing.lex_backtrk = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\011\000\
    \255\255\002\000\255\255\004\000\255\255\255\255\255\255\009\000\
    \255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_default = 
   "\255\255\000\000\000\000\000\000\000\000\000\000\000\000\255\255\
    \000\000\255\255\255\255\255\255\000\000\000\000\000\000\255\255\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \002\000\003\000\004\000\005\000\006\000\007\000\000\000\008\000\
    \009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
    \009\000\009\000\010\000\011\000\019\000\012\000\020\000\009\000\
    \009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
    \009\000\018\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\013\000\000\000\014\000\000\000\015\000\
    \000\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\016\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\000\000\
    \000\000\000\000\000\000\015\000\000\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\010\000\000\000\007\000\009\000\
    \009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
    \009\000\011\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\000\000\255\255\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\015\000\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\255\255\
    \255\255\255\255\255\255\015\000\255\255\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
    \015\000\015\000\015\000\015\000\015\000\015\000\015\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255"
}

let rec token lexbuf = __ocaml_lex_token_rec lexbuf 0
and __ocaml_lex_token_rec lexbuf state =
  match Lexing.engine lex_tables state lexbuf with
    0 -> (
# 27 "miniMLLexer.mll"
                    token lexbuf )
  | 1 -> (
# 28 "miniMLLexer.mll"
         EOD )
  | 2 -> (
# 29 "miniMLLexer.mll"
               INT(int_of_string(Lexing.lexeme lexbuf)) )
  | 3 -> (
# 30 "miniMLLexer.mll"
         CONS )
  | 4 -> (
# 31 "miniMLLexer.mll"
        SEMICOLON )
  | 5 -> (
# 32 "miniMLLexer.mll"
        BAR )
  | 6 -> (
# 33 "miniMLLexer.mll"
        LBRACKET )
  | 7 -> (
# 34 "miniMLLexer.mll"
        RBRACKET )
  | 8 -> (
# 35 "miniMLLexer.mll"
         ARROW )
  | 9 -> (
# 36 "miniMLLexer.mll"
                          let s = Lexing.lexeme lexbuf in
			try identifier_of(s) with _ -> IDENT(s) )
  | 10 -> (
# 38 "miniMLLexer.mll"
        PLUS )
  | 11 -> (
# 39 "miniMLLexer.mll"
        MINUS )
  | 12 -> (
# 40 "miniMLLexer.mll"
        TIMES )
  | 13 -> (
# 41 "miniMLLexer.mll"
        DIV )
  | 14 -> (
# 42 "miniMLLexer.mll"
        EQUAL )
  | 15 -> (
# 43 "miniMLLexer.mll"
        LPAREN )
  | 16 -> (
# 44 "miniMLLexer.mll"
        RPAREN )
  | 17 -> (
# 45 "miniMLLexer.mll"
        COMMA )
  | 18 -> (
# 46 "miniMLLexer.mll"
        raise Eof )
  | n -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_token_rec lexbuf n

;;

