open MiniML

(* let failwith s = raise (Failure s) *)

let rec get id = function
    [] -> raise (Failure ("Unbound value " ^ id))
  | (i, v) :: ls ->
      if i = id then 
	(match !v with
	  Undefined -> failwith "using undefined value with letrec"
	| x -> x)
      else get id ls

let get_int = function
    Int(v1) -> v1 | _ -> failwith "not an int value"

let get_bool = function
    Bool(v1) -> v1 | _ -> failwith "not a bool value"

exception MatchFailed

(* val eval : env * expr -> mlvalue *)

let rec eval env = function
    Const(v) -> v
  | Var(id) -> get id env
  | Plus(e1, e2) -> 
      Int(get_int (eval env e1) + get_int (eval env e2))
  | Minus(e1, e2) -> 
      Int(get_int (eval env e1) - get_int (eval env e2))
  | Times(e1, e2) -> 
      Int(get_int (eval env e1) * get_int (eval env e2))
  | Div(e1, e2) -> 
      Int(get_int (eval env e1) / get_int (eval env e2))
  | Equal(e1, e2) ->
      Bool((eval env e1) = (eval env e2))
  | ConsExp(e1, e2) ->
      Cons(eval env e1, eval env e2)
  | IfExp(ec, e1, e2) ->
      if get_bool (eval env ec) then eval env e1 else eval env e2
  | LambdaExp [p1, e] ->
      Closure([p1, e], env)
  | LambdaExp ps -> (* only for optional *)
      Closure(ps, env)
  | App(e1, e2) -> begin
      match eval env e1 with
	Closure([IdentPtn arg, body], i_env) -> ... (* required *)
      |	Closure(pats, i_env) ->
	  failwith "unsupported expression" (* optional *)
      |	_ -> failwith "applying value to non-closure"
  end
  | MatchExp(exp,pats) -> ... (* required *)
  | LetExp([IdentPtn id, e1], e2) ->
      let v1 = eval env e1 in
      eval ((id, ref v1) :: env) e2
  | LetExp(ptns, e2) -> failwith "unsupported expression" (* optional *)
  | LetRecExp([IdentPtn id, e1], e2) -> ... (* required *)
  | LetRecExp(ptns, e2) ->
      failwith "unsupported expression" (* optional, slightly difficult *)
  | _ -> failwith "invalid expression"

