type environment = (string * mlvalue ref) list
(* note: value part is mlvalue ref (to support LET REC) *)

(* miniML values *)
and mlvalue = 
    Int of int
  | Bool of bool
  | Cons of mlvalue * mlvalue
  | Pair of mlvalue * mlvalue
  | Nil
  | Closure of (pattern * expr) list * environment
  | Undefined

(* miniML identifiers *)
and ident = string

(* miniML expressions *)
and expr =
  | Const of mlvalue
  | Var of ident
  | Plus of expr * expr
  | Minus of expr * expr
  | Times of expr * expr
  | Div of expr * expr
  | Equal of expr * expr
  | PairExp of expr * expr
  | ConsExp of expr * expr
  | IfExp of expr * expr * expr
  | LambdaExp of (pattern * expr) list
  | App of expr * expr
  | MatchExp of expr * (pattern * expr) list
  | LetExp of (pattern * expr) list * expr
  | LetRecExp of (pattern * expr) list * expr
(* following two constructor is not used *)
  | TopLetExp of (pattern * expr) list
  | TopLetRecExp of (pattern * expr) list

(* miniML pattern expressions *)
and pattern =
  | ConstPtn of mlvalue
  | IdentPtn of ident
  | ConsPtn of pattern * pattern
  | PairPtn of pattern * pattern
